using System;
using System.Collections;
using System.Reflection;
using System.Drawing.Printing;
using System.Data;
using System.Text;

namespace gov.va.med.vbecs.BOL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///<Developer>Greg Lohse</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>8/24/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Summary description for SupplyInventoryReport</summary>

	#endregion

	public class SupplyInventoryReport : VbecsReport
	{
		#region Variables

		//In-Date is the default
		private Common.SupplyInventoryReportFilter _inventoryFilter = Common.SupplyInventoryReportFilter.InDate;

		private System.DateTime __expirationStartDate = System.DateTime.MinValue;
		private System.DateTime _receiptStartDate = System.DateTime.MinValue;

		private System.DateTime _expirationEndDate = System.DateTime.MaxValue;
		private System.DateTime _receiptEndDate = System.DateTime.MaxValue;
		
		private System.Collections.ArrayList _supplyTypeIds = new System.Collections.ArrayList();

		#endregion


		#region Consructors

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/25/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1783"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Initialized SupplyInventoryReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1784"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// SupplyInventoryReport
		/// </summary>
		public SupplyInventoryReport()
		{
		}

		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/25/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4331"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Initialized SupplyInventoryReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4332"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// SupplyTypeId's wanted to use in this deal
		/// </summary>
		public System.Collections.ArrayList SupplyTypeIds
		{
			get
			{
				return(this._supplyTypeIds);
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/25/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1789"> 
		///		<ExpectedInput>SupplyInventoryReportFilter</ExpectedInput>
		///		<ExpectedOutput>SupplyInventoryReportFilter</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1790"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// InventoryFilter
		/// </summary>
		public Common.SupplyInventoryReportFilter InventoryFilter
		{
			get
			{
				return(this._inventoryFilter);
			}
			set
			{
				switch(value)
				{
					case Common.SupplyInventoryReportFilter.InDate:
						break;
					case Common.SupplyInventoryReportFilter.Unsatisfactory:
						break;
					case Common.SupplyInventoryReportFilter.Expired:
						this._expirationEndDate = System.DateTime.MaxValue;
						this.__expirationStartDate = System.DateTime.MinValue;
						break;
					case Common.SupplyInventoryReportFilter.ExpiredWithDateRange:
						break;
				}
					
				this._inventoryFilter = value;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/25/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1797"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1798"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ReceiptStartDate
		/// </summary>
		public System.DateTime ReceiptStartDate
		{
			get
			{
				return(this._receiptStartDate);
			}
			set
			{
				this._receiptStartDate = value;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/25/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4009"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4010"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ReceiptEndDate
		/// </summary>
		public System.DateTime ReceiptEndDate
		{
			get
			{
				return(this._receiptEndDate);
			}
			set
			{
				this._receiptEndDate = value;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/25/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1799"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1800"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ExpirationStartDate
		/// </summary>
		public System.DateTime ExpirationStartDate
		{
			get
			{
				return(this.__expirationStartDate);
			}
			set
			{
				this.__expirationStartDate = value;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/25/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1801"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1802"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ExpirationEndDate
		/// </summary>
		public System.DateTime ExpirationEndDate
		{
			get
			{
				return(this._expirationEndDate);
			}
			set
			{
				this._expirationEndDate = value;
			}
		}

		#endregion


		#region Methods

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/25/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1785"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable containing Supply Inventory report data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1786"> 
		///		<ExpectedInput>Invalid object parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Generate data source for Supply Inventory Report
		/// </summary>
		/// <returns></returns>
		public DataTable GetSupplyInventoryReport()
		{
			bool includeUnsatisfactory = (this.InventoryFilter == Common.SupplyInventoryReportFilter.Unsatisfactory);

			//Do some automatic date setting  if needed
			switch (this.InventoryFilter)
			{
				case Common.SupplyInventoryReportFilter.InDate:
				{
					this.ExpirationEndDate = System.DateTime.MaxValue;
					this.ExpirationStartDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
					break;
				}
				case Common.SupplyInventoryReportFilter.Expired:
				{
					this.ExpirationEndDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
					this.ExpirationStartDate = System.DateTime.MinValue;
					break;
				}
			}

			string supplyTypeIds = string.Empty;
			//Build a comma delimited string of the SupplyType Ids
			if (this.SupplyTypeIds.Count > 0)
			{
				for (int ndx=0; ndx < this.SupplyTypeIds.Count; ndx++)
				{
					supplyTypeIds += this.SupplyTypeIds[ndx].ToString();

					if (ndx < this.SupplyTypeIds.Count - 1)
					{
						supplyTypeIds += ",";
					}
				}
			}

			System.Data.DataTable dtReport = DAL.Supply.GetSupplyInventoryReportData(this.ReceiptStartDate, this.ReceiptEndDate, 
				this.ExpirationStartDate, this.ExpirationEndDate, includeUnsatisfactory, supplyTypeIds);
			return(dtReport);
		}

		#endregion

		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7741"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7742"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Generate and print report
		/// Used by VbecsConsoleReport application
		/// </summary>
        protected override VbecsReportPrinter createReportPrinter()
        {
            return null;
        }
	}
}
